/* global require,ELEMENT,Vue */
/*jshint -W083,-W061 */

let {
	ipcRenderer
} = require("electron");
ELEMENT.locale(ELEMENT.lang.ja);
let app = new Vue({
	el: '#app',
	data: () => {
		return {
			form:{
				code:'',
				type:'instagram',
				username: '',
				password: '',
				tagname: '',
				since: '',
				until: '',
				range: 1000,
				directory:'',
				outputs: ['HTML'],
			},
			password:'password',
			lock:false,
			logger:''
		};
	},
	watch: {
		form: {
			handler: function(val, oldVal) {
				ipcRenderer.invoke('set', {
					key:'form',
					value:val
				});
			},
			deep: true
		}
	},
	methods: {
		selectDirectory: async () => {
			app.form.directory = await ipcRenderer.invoke('select-dir');
		},
		getHash: async () => {
			await ipcRenderer.invoke('get-hash', app.form);
		},
		getHashCancel: async () => {
			await ipcRenderer.invoke('get-hash-cancel');
		}
	},
	mounted : async function(){
		let form = await ipcRenderer.invoke('get', {key:'form'});
		if(form){
			this.form = form;	
		}
		ipcRenderer.on("logger", (event, result) => {
			this.logger = result;
		});
		ipcRenderer.on("lock", (event, result) => {
			this.lock = true;
		});
		ipcRenderer.on("unlock", (event, result) => {
			this.lock = false;
		});
	}
});