<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

### Table of Contents

-   [initialize][1]
    -   [Parameters][2]
-   [connect][3]
    -   [Parameters][4]
-   [getPage][5]
    -   [Parameters][6]

## initialize

Initialize the electron app to accept puppeteer/DevTools connections.
Must be called at startup before the electron app is ready.

### Parameters

-   `app` **App** The app imported from electron.
-   `port` **[number][7]** Port to host the DevTools websocket connection. (optional, default `0`)

## connect

Connects puppeteer to the electron app. Must call [initialize][8] before connecting.
When connecting multiple times, you use the same port.

### Parameters

-   `app` **App** The app imported from electron.
-   `puppeteer` **puppeteer** The imported puppeteer namespace.

Returns **[Promise][9]&lt;Browser>** An object containing the puppeteer browser, the port, and json received from DevTools.

## getPage

Given a BrowserWindow, find the corresponding puppeteer Page. It is undefined if external operations
occur on the page whilst we are attempting to find it. A url/file must be loaded on the window for it to be found.
If no url is loaded, the parameter 'allowBlankNavigate' allows us to load "about:blank" first.

### Parameters

-   `browser` **Browser** The puppeteer browser instance obtained from calling |connect|.
-   `window` **BrowserWindow** The browser window for which we want to find the corresponding puppeteer Page.
-   `allowBlankNavigate` **[boolean][10]** If no url is loaded, allow us to load "about:blank" so that we may find the Page. (optional, default `true`)

Returns **[Promise][9]&lt;Page>** The page that corresponds with the BrowserWindow.

[1]: #initialize

[2]: #parameters

[3]: #connect

[4]: #parameters-1

[5]: #getpage

[6]: #parameters-2

[7]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[8]: initialize

[9]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise

[10]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean
