# Installation
> `npm install --save @types/async-retry`

# Summary
This package contains type definitions for async-retry (https://github.com/zeit/async-retry#readme).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/async-retry.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/async-retry/index.d.ts)
````ts
// Type definitions for async-retry 1.4
// Project: https://github.com/zeit/async-retry#readme
// Definitions by: Albert Wu <https://github.com/albertywu>
//                 Pablo Rodríguez <https://github.com/MeLlamoPablo>
//                 Rafał Sawicki <https://github.com/rafsawicki>
// Definitions: https://github.com/DefinitelyTyped/DefinitelyTyped
// TypeScript Version: 2.3

import { OperationOptions } from 'retry';

declare function AsyncRetry<A>(
    fn: AsyncRetry.RetryFunction<A>,
    opts?: AsyncRetry.Options
): Promise<A>;

declare namespace AsyncRetry {
    interface Options extends OperationOptions {
        onRetry?: ((e: Error, attempt: number) => any) | undefined;
    }

    type RetryFunction<A> = (bail: (e: Error) => void, attempt: number) => A|Promise<A>;
}

export = AsyncRetry;

````

### Additional Details
 * Last updated: Tue, 06 Jul 2021 18:05:36 GMT
 * Dependencies: [@types/retry](https://npmjs.com/package/@types/retry)
 * Global values: none

# Credits
These definitions were written by [Albert Wu](https://github.com/albertywu), [Pablo Rodríguez](https://github.com/MeLlamoPablo), and [Rafał Sawicki](https://github.com/rafsawicki).
