// LICENSE : MIT
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

exports.getTokenizer = getTokenizer;
exports.tokenize = tokenize;

var _Deferred = require("./Deferred");

var _Deferred2 = _interopRequireDefault(_Deferred);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var path = require("path");
var kuromoji = require("kuromoji");


var deferred = new _Deferred2.default();
var getNodeModuleDirPath = function getNodeModuleDirPath() {
    // Node
    if (typeof process !== "undefined" && _typeof(process.env) === "object" && process.env.KUROMOJIN_DIC_PATH) {
        return process.env.KUROMOJIN_DIC_PATH;
    }
    // if window.kuromojin.dicPath is defined, use it as default dict path.
    if (typeof window !== "undefined" && _typeof(window.kuromojin) === "object" && typeof window.kuromojin.dicPath === "string") {
        return window.kuromojin.dicPath;
    }
    var kuromojiDir = path.dirname(require.resolve("kuromoji"));
    return path.join(kuromojiDir, "..", "dict");
};
// cache for tokenizer
var _tokenizer = null;
// lock boolean
var isLoading = false;

function getTokenizer() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : { dicPath: getNodeModuleDirPath() };

    if (_tokenizer) {
        return Promise.resolve(_tokenizer);
    }
    if (isLoading) {
        return deferred.promise;
    }
    isLoading = true;
    // load dict
    kuromoji.builder(options).build(function (err, tokenizer) {
        if (err) {
            return deferred.reject(err);
        }
        _tokenizer = tokenizer;
        deferred.resolve(tokenizer);
    });
    return deferred.promise;
}

function tokenize(text) {
    return getTokenizer().then(function (tokenizer) {
        return tokenizer.tokenizeForSentence(text);
    });
}
//# sourceMappingURL=kuromojin.js.map